-- vertex_lists.lua
-- A collection of vertex array data for some simple shapes.

local vertex_lists = {
    tetra = {
        -- TODO: separate
        verts = {
            0,2.598,0, -- A
            0,0,1.732, -- B
            -1.5,0,-.866, -- C

            0,2.598,0, -- A
            -1.5,0,-.866, -- C
            1.5,0,-.866, -- D

            0,2.598,0, -- A
            1.5,0,-.866, -- D
            0,0,1.732, -- B

            -1.5,0,-.866, -- C
            0,0,1.732, -- B
            1.5,0,-.866, -- D
        },
        -- AB == {0, -2.598, 1.732}
        -- AC == {-1.5, -2.598, -.866}
        -- AD == {1.5, -2.598, -.866}
        -- BC == {-1.5, 0, -.866}
        -- BD == {-1.5, 0, -2.598}
        -- CD == {3, 0, 0}
        norms = {
            6.75, -2.598, -3.897,
            6.75, -2.598, -3.897,
            6.75, -2.598, -3.897,
            6.75, -2.598, -3.897,

            0,-2.598,7.794,
            0,-2.598,7.794,
            0,-2.598,7.794,
            0,-2.598,7.794,

            6.75,2.598,3.897,
            6.75,2.598,3.897,
            6.75,2.598,3.897,
            6.75,2.598,3.897,

            0,2.598,0,
            0,2.598,0,
            0,2.598,0,
            0,2.598,0,
        },
        texs = {
            0,0,0,
            1,0,0,
            0,1,0,
            1,1,0,

            0,0,0,
            1,0,0,
            0,1,0,
            1,1,0,

            0,0,0,
            1,0,0,
            0,1,0,
            1,1,0,

            0,0,0,
            1,0,0,
            0,1,0,
            1,1,0,
        },
        tris = {
            0,1,2,
            3,4,5,
            6,7,8,
            9,10,11
        },
    },
    square = {
        verts = {
            0,0,0,
            1,0,0,
            1,1,0,
            0,1,0,
        },
        norms = {
        --[[0,0,1,
            1,0,1,
            1,1,1,
            0,1,0,]]
            0,0,1,
            0,0,1,
            0,0,1,
            0,0,1,
        },
        texs = {
            0,0,0,
            1,0,0,
            1,1,0,
            0,1,0,
        },
        tris = {
            0,1,2,
            0,2,3,
        },
    },
    halfcube = {
        verts = {
            0,0,0,
            1,0,0,
            1,1,0,
            0,1,0,

            0,0,0,
            1,0,0,
            1,0,1,
            0,0,1,

            0,0,0,
            0,1,0,
            0,1,1,
            0,0,1,
        },
        norms = {
            0,0,1,
            0,0,1,
            0,0,1,
            0,0,1,

            0,1,0,
            0,1,0,
            0,1,0,
            0,1,0,

            1,0,0,
            1,0,0,
            1,0,0,
            1,0,0,
        },
        texs = {
            0,0,0,
            1,0,0,
            1,1,0,
            0,1,0,

            0,0,0,
            1,0,0,
            1,0,1,
            0,0,1,

            0,0,0,
            0,1,0,
            0,1,1,
            0,0,1,
        },
        tris = {
            0,1,2,
            0,2,3,
            4,5,6,
            4,6,7,
            8,9,10,
            8,10,11,
        },
    },
    cube = {
        verts = {
            0,0,0,
            1,0,0,
            1,1,0,
            0,1,0,

            0,0,0,
            1,0,0,
            1,0,1,
            0,0,1,

            0,0,0,
            0,1,0,
            0,1,1,
            0,0,1,

            0,0,1,
            1,0,1,
            1,1,1,
            0,1,1,

            0,1,0,
            1,1,0,
            1,1,1,
            0,1,1,

            1,0,0,
            1,1,0,
            1,1,1,
            1,0,1,
        },
        norms = {
            0,0,1,
            0,0,1,
            0,0,1,
            0,0,1,

            0,1,0,
            0,1,0,
            0,1,0,
            0,1,0,

            1,0,0,
            1,0,0,
            1,0,0,
            1,0,0,
            -- negative, whatever
            0,0,1,
            0,0,1,
            0,0,1,
            0,0,1,

            0,1,0,
            0,1,0,
            0,1,0,
            0,1,0,

            1,0,0,
            1,0,0,
            1,0,0,
            1,0,0,
        },
        texs = {
            0,0,0,
            1,0,0,
            1,1,0,
            0,1,0,
            
            0,0,0,
            1,0,0,
            1,1,0,
            0,1,0,
            
            0,0,0,
            1,0,0,
            1,1,0,
            0,1,0,
            
            0,0,0,
            1,0,0,
            1,1,0,
            0,1,0,
            
            0,0,0,
            1,0,0,
            1,1,0,
            0,1,0,
            
            0,0,0,
            1,0,0,
            1,1,0,
            0,1,0,
        },
        tris = {
            0,1,2,
            0,2,3,
            4,5,6,
            4,6,7,
            8,9,10,
            8,10,11,
            12,13,14,
            12,14,15,
            16,17,18,
            16,18,19,
            20,21,22,
            20,22,23,
        },
    },
}

return vertex_lists
